/**
 * De klasse drankautomaat beschrijft de werking van een drankautomaat.
 * Je kan enkel euromuntstukken vanaf 5 cent in de automaat steken.
 * Geld kan op drie plaatsen zitten:
 *  1)Na een verkoop: geldlade van de drankautomaat.
 *  2)Voor een verkoop: geldlade van ingeworpen munten.
 *  3)Na een verkoop of geld terug voor verkoop: geldlade voor wisselgeld.
 * De prijzen en de soorten drankjes staan vast:
 *      water: 0.60 euro
 *      cola, fanta, sprite: 0.90 euro
 *      fruitsap: 1.20 euro
 * Van elke drank zitten initieel 20 blikjes in de automaat.
 * 
 * @author Dominiek Vandewalle
 * @version 2014-09-16
 */
public class Drankautomaat
{
    // Velden
    private double bedragInAutomaat;//geldlade van de automaat
    private double ingeworpenBedrag; //geldlade van ingeworpen munten
    private double wisselgeld; //geldlade voor het wisselgeld.
    private int aantalWater;
    private int aantalCola;
    private int aantalFanta;
    private int aantalSprite;
    private int aantalFruitsap;

    /**
     * Constructor voor objecten van de klasse Drankautomaat.
     */
    public Drankautomaat()
    {
        bedragInAutomaat = 0;
        ingeworpenBedrag = 0;
        wisselgeld = 0;
        aantalWater = 20;
        aantalCola  = 20;
        aantalFanta  = 20;
        aantalSprite = 20;
        aantalFruitsap = 20;
    }
    
    /**
     * Toont het bedrag in de geldlade van de drankautomaat.
     * @return     Het totale bedrag dat in de drankautomaat zit.
     */
    public double getBedragInAutomaat()
    {
        return bedragInAutomaat;
    }
    
    /**
     * Toont het bedrag in de geldlade van de ingeworpen munten.
     * @return     Het ingeworpen bedrag.
     */
    public double getIngeworpenBedrag()
    {
        return ingeworpenBedrag;
    }
    
    /**
     * Laat de ingeworpen munten terug in het wisselgeldbakje vallen.
     */
    public void geefMuntenTerug()
    {
        wisselgeld += ingeworpenBedrag;
        ingeworpenBedrag = 0;
    }
    
    /**
     * Geeft de inhoud van het wisselgeldbakje terug.
     * Het wisselgeldbakje is nu terug leeg.
     * @return     Het bedrag in het wisselgeldbakje.
     */
    public double neemWisselGeldTerug()
    {
        double hulp;
        hulp = wisselgeld;
        wisselgeld = 0;
        return hulp;
    }
    
    /**
     * Voegt een muntstuk toe aan de geldlade van de
     * ingeworpen munten. 
     * Laat enkel munten van 0.05, 0.10, 0.20, 0.50, 1.00, 2.00 toe.
     * @param  muntstuk  De waarde van het muntstuk.
     */
    public void werpMuntstukIn(double muntstuk)
    {
        //schrijf je eigen code.
    }
    
    /**
     * Vermindert het aantal drankjes van een bepaalde soort met 1
     * indien:
     *      1) Er voldoende geld ingeworpen werd.
     *      2) Het drankje nog in voorraad is.
     * Laat het eventueel wisselgeld in de geldlade voor wisselgeld 
     * vallen en voegt het aankoopbedrag toe aan de geldlade van de
     * drankautomaat.
     * @param  drankje  Het gekozen drankje.
     */
    public void kiesDrankje(String drankje)
    {
        //schrijf je eigen code. Maak gebruik van andere methodes.
    }
    
    /**
     * Geeft de prijs van een drankje terug
     * @param  drankje  De naam van het drankje.
     * @return          De prijs van het drankje.
     */
    public double prijsDrankje(String drankje)
    {
        double prijs;
        
        //verwijder onderstaande regel en schrijf je eigen code.
        prijs = 0;
        
        return prijs;
    }
    
    /**
     * Geeft aan hoeveel drankjes van een bepaalde soort nog in de
     * automaat zitten.
     * @param  drankje  De naam van het drankje.
     * @return     Aantal drankjes aanwezig in de automaat.
     */
    private int aantalDrankjesInAutomaat(String drankje)
    {
        int aantal;
        
        //verwijder onderstaande regel en schrijf je eigen code.
        aantal = 0;
        
        return aantal;        
    }
    
    /**
     * Vermindert het aantal drankjes in de drankautomaat met 1.
     * @param  drankje  De naam van het drankje.
     */
    private void verminderAantalDrankjes(String drankje)
    {   
        //vul de code verder aan. 
    }
}
